define([
    'backbone',
    'Layout',
    'App',
    'modules/form/question-view',
    'modules/form/section-view',
    'modules/new-appointment-request/views/requests/express-care/section-view',
],
function(Backbone, Layout, app, QuestionView, SectionView, ExpressCareReasonSectionView) {
    'use strict';

    describe('Express Care Reason Section View', function() {
        var view;
        var $view;
        var layout = new Layout();
        layout.render();

        beforeEach(function() {
            spyOn(QuestionView.prototype, 'addFormValidationRules');
            spyOn(SectionView.prototype, 'hideValidationErrorsFor');

            view = new ExpressCareReasonSectionView({
                model: new Backbone.Model(),
                reasons: new Backbone.Collection([
                    {
                        id: '0',
                        name: 'Sluggishness',
                    },
                    {
                        id: '1',
                        name: 'Allergic Reaction',
                    },
                    {
                        id: 'ZZ',
                        name: 'Other',
                    },
                ]),
            });
            layout.showChildView('fDNS   tent', view);
            $view = view.$el;
        });
        afterEach(function() {
            layout.getRegion('fDNS   tent').empty();
        });
        it('initializes with all questions', function() {
            expect(view.collection.length).toEqual(3);
            expect(view.collection.at(0).id).toEqual('reasonForVisit');
            expect(view.collection.at(0).get('type')).toEqual('select');
            expect(view.collection.at(0).get('label')).toEqual('Reason for Visit:');

            expect(view.collection.at(1).id).toEqual('otherReasonForVisit');
            expect(view.collection.at(1).get('type')).toEqual('text');
            expect(view.collection.at(1).get('label')).toEqual('Other Reason:');

            expect(view.collection.at(2).id).toEqual('additionalInformation');
            expect(view.collection.at(2).get('type')).toEqual('textarea');
            expect(view.collection.at(2).get('maxlength')).toEqual(250);
            expect(view.collection.at(2).get('label')).toEqual('Additional Information');
        });

        it('has instructions', function() {
            expect($view.find('.express-care-instructions').text()).toEqual('Express Care visits are available only for certain cases.');
        });

        it('initially hides the Other Reason question', function() {
            expect($view.find('.other-question').is('.hidden')).toBe(true);
        });

        it("shows the Other Reason question when 'Other' is selected", function() {
            $view.find('#reasonForVisit').val('ZZ')
                .trigger('change');
            expect($view.find('.other-question').is('.hidden')).toBe(false);
        });

        it('hides the Other Reason question when another Reason is selected', function() {
            $view.find('#reasonForVisit').val('ZZ')
                .trigger('change');
            expect($view.find('.other-question').is('.hidden')).toBe(false);

            $view.find('#reasonForVisit').val('1')
                .trigger('change');
            expect($view.find('.other-question').is('.hidden')).toBe(true);
        });
    });
});
